﻿var timeslots = {
    context: $(".v-callbacks-timeslots"),
    datatable: null,
    initializeDataTable: function () {
        this.datatable = $(".h-timeslots-table", this.context).a4datatable({
            displaySearchBox: false,
            height: "full",
            multiEdit: true,
            ajaxAction: a4.getProjectAction("GetTimeSlots", "CallBacks"),
            columns: [
                { "Title": resources.Number, "Name": "Id", "Data": "Slot", "Key": true },
                { "Title": resources.Monday, "Name": "Day2", "ShowIcon": true, "Type": "boolean", "Editable": true },
                { "Title": resources.Tuesday, "Name": "Day3", "ShowIcon": true, "Type": "boolean", "Editable": true },
                { "Title": resources.Wednesday, "Name": "Day4", "ShowIcon": true, "Type": "boolean", "Editable": true },
                { "Title": resources.Thursday, "Name": "Day5", "ShowIcon": true, "Type": "boolean", "Editable": true },
                { "Title": resources.Friday, "Name": "Day6", "ShowIcon": true, "Type": "boolean", "Editable": true },
                { "Title": resources.Saturday, "Name": "Day7", "ShowIcon": true, "Type": "boolean", "Editable": true },
                { "Title": resources.Sunday, "Name": "Day1", "ShowIcon": true, "Type": "boolean", "Editable": true },
                { "Title": resources.Begin, "Data": "StartTimeFormatted", "Name": "StartTime", "Editable": true, "Type": "time" },
                { "Title": resources.End, "Data": "EndTimeFormatted", "Name": "EndTime", "Editable": true, "Type": "time" },
                { "Title": resources.MaxCounter, "Name": "MaxCounter", "Editable": { "MinValue": 0, "MaxValue": 1000000000 }, "Type": "numeric" },
                { "Title": resources.ResetOnLevelChange, "Name": "ResetOnLevelChange", "ShowIcon": true, "Type": "boolean", "Editable": true },
                { "Title": resources.ScatteringDistribution, "Name": "TimeSlotUsageRange", "Editable": { "MinValue": 0, "MaxValue": 100 }, "Type": "numeric" },
                { "Title": resources.TimeSlotCounterFullOverride, "Name": "TimeSlotRestrictionOverride", "Editable": true, "Type": "enum", "EnumType": "TimeSlotCounterFullOverrideEnum" }
            ],
            stateKey: "CallbackTimeSlots",
            toolBarItems: [
                { "Action": "delete", "Label": resources.Delete }
            ],
            contextMenuItems: [
                { "Action": "delete", "Label": resources.Delete },
                { "Action": "properties", "Label": resources.Properties }
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "delete":
                        timeslots.deleteTimeSlots([row.Id]);
                        break;
                    case "properties":
                        timeslots.editTimeSlots(row.Id);
                        break;
                }
            },
            toolBarClick: function (event, data) {
                var ids = _.pluck(data.rows, "Id");

                if (data.action == "delete") {
                    timeslots.deleteTimeSlots(ids);
                }
            },
            rowUpdated: function (event, data) {
                if (data.value === "")
                    data.flagError(true);

                if (data.fieldName == "MaxCounter" && (data.value < 0 || data.value > 999999999))
                    data.flagError(true);
                else if (data.fieldName == "TimeSlotUsageRange" && (data.value < 0 || data.value > 100))
                    data.flagError(true);

                var row = data.data;

                if (!(row.Day1 || row.Day2 || row.Day3 || row.Day4 || row.Day5 || row.Day6 || row.Day7))
                    data.flagError(true, true);
            },
            rowsUpdated: function (event, data) {
                a4.callServerMethod(a4.getProjectAction("UpdateTimeSlots", "CallBacks"), { timeslots: data.rows }, function () {
                    data.multiEditSaveCallback();
                });
            },
            cellCreated: function (event, data) {
                if (data.fieldName == "MaxCounter" && data.row.CountTimeSlotCounters > 0)
                    $(data.cell).css("color", "#eb6725");
            }
        });
    },
    bindEvents: function () {
        timeslots.context.on("click", ".h-add-timeslots", function () {
            modalDialog.showWindow(a4.getProjectAction("EditTimeSlot", "CallBacks"), 650, 750, { afterClose: function () { timeslots.refreshContent(); } });
        });

        timeslots.context.on("click", ".h-copyTimeSlots", function () {
            a4.showSelectProjectDialog(function (sourceProjectId) {
                a4.callServerMethod(a4.getProjectAction("CopyTimeSlots", "CallBacks"), { sourceProjectId: sourceProjectId },
                function (result) {
                    timeslots.refreshContent();
                });
            }, resources.CopyTimeslotFrom);
        });

        timeslots.context.on("click", ".h-settings", function () {
            modalDialog.showWindow(a4.getProjectAction("TimeSlotSettings", "CallBacks"), 250, 600, { afterClose: function () { timeslots.refreshContent(); } });
        });
    },
    deleteTimeSlots: function (timeslotIds) {
        modalDialog.showConfirmDelete(confirmDeleteTimeSlotsResources, function () {
            a4.callServerMethod(a4.getProjectAction("DeleteTimeSlots", "CallBacks"), { timeslotIds: timeslotIds },
                function (result) {
                    timeslots.refreshContent();
                });
        }, timeslotIds.length);
    },
    editTimeSlots: function (timeslotId) {
        modalDialog.showWindow(a4.getProjectAction("EditTimeSlot", "CallBacks", { timeslotId: timeslotId }), 650, 700, { afterClose: function () { timeslots.refreshContent(); } });
    },
    refreshContent: function () {
        this.datatable.a4datatable("refresh");
    }
};

$(document).ready(function () {
    if (timeslots.context.length > 0) {
        timeslots.initializeDataTable();
        timeslots.bindEvents();
    }
});